<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" 
				xmlns:MSHelp="http://msdn.microsoft.com/mshelp"
        xmlns:mshelp="http://msdn.microsoft.com/mshelp"
				xmlns:ddue="http://ddue.schemas.microsoft.com/authoring/2003/5"
				xmlns:xlink="http://www.w3.org/1999/xlink"
        xmlns:msxsl="urn:schemas-microsoft-com:xslt"
         >

  <xsl:import href="globalTemplates.xsl"/>
  <xsl:template name="upperBodyStuff">
    <input type="hidden" id="userDataCache" class="userDataStyle"/>
    <input type="hidden" id="hiddenScrollOffset"/>
    
    <xsl:call-template name="commonImages"/>

    <xsl:call-template name="bodyHeader"/>
    
  </xsl:template>

  <xsl:template name="bodyHeader">
    <div id="header">
      <xsl:call-template name="bodyHeaderTopTable"/>
    </div>
  </xsl:template>

  <xsl:template name="bodyHeaderTopTable">
    <table id="topTable">
      <tr id="headerTableRow3">
        <td>
          <xsl:call-template name="headerRowLinks"/>
        </td>
      </tr>
      <tr id="headerTableRow1">
        <td align="left">
          <span id="runningHeaderText">
            <xsl:call-template name="runningHeader" />
          </span>
        </td>
      </tr>
      <tr id="headerTableRow2">
        <td align="left">
          <span id="nsrTitle">
            <xsl:call-template name="topicTitleDecorated"/>
          </span>
        </td>
      </tr>
      <tr>
        <td class="nsrBottom">
          <includeAttribute name="background" item="iconPath">
            <parameter>NSRbottomgrad.gif</parameter>
          </includeAttribute>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="headerRowLinks">
    <!-- most mref topics get autogenerated see also links to see also section -->

    <span onclick="ExpandCollapseAll(toggleAllImage)" style="cursor:default;" onkeypress="ExpandCollapseAll_CheckKey(toggleAllImage, event)" tabindex="0">
      <img ID="toggleAllImage" class="toggleAll">
        <includeAttribute name="src" item="iconPath">
          <parameter>collall.gif</parameter>
        </includeAttribute>
	<includeAttribute name="title" item="collapseAllImage" />
      </img>
      <label id="collapseAllLabel" for="toggleAllImage" style="display: none;">
        <include item="collapseAll"/>
      </label>
      <label id="expandAllLabel" for="toggleAllImage" style="display: none;">
        <include item="expandAll"/>
      </label>
      <xsl:text>&#160;</xsl:text>
    </span>

    <xsl:if test="$languages != 'false'">
    	<xsl:if test="count($languages/language) &gt; 0">
        <xsl:text>&#160;|&#160;</xsl:text>
    		<xsl:call-template name="languageFilterToolTip"/>
    		<xsl:call-template name="languageSpan"/>
    	</xsl:if>
    </xsl:if>
  
    
    <!-- include Example link if there's an Example section -->
    <xsl:choose>
      <xsl:when test="$examplesSection">
        <xsl:text>&#160;|&#160;</xsl:text>
        <a href="#exampleToggle" onclick="OpenSection(exampleToggle)">
          <xsl:text/>
          <include item="Example"/>
          <xsl:text/>
        </a>
       </xsl:when>
    </xsl:choose>

    <!-- class, structure, and interface About topics get link to Members topic (unless the doc model has the all members lists on the type topic) -->
    <xsl:choose>
      <xsl:when test="normalize-space(/document/reference/topicdata/@allMembersTopicId)">
        <xsl:text>&#160;|&#160;</xsl:text>
        <referenceLink target="{/document/reference/topicdata/@allMembersTopicId}">
          <include item="allMembersTitle"/>
        </referenceLink>
      </xsl:when>
      <xsl:when test="count(/document/reference/elements/element) &gt; 0 and ($subgroup='class' or $subgroup='structure' or $subgroup='interface')">
        <xsl:text>&#160;|&#160;</xsl:text>
        <a href="#membersToggle" onclick="OpenSection(membersToggle)">
          <xsl:text/>
          <include item="allMembersTitle"/>
          <xsl:text/>
        </a>
      </xsl:when>
    </xsl:choose>

    <xsl:if test="$hasSeeAlsoSection">
      <xsl:text>&#160;|&#160;</xsl:text>
      <a href="#seeAlsoToggle" onclick="OpenSection(seeAlsoToggle)">
        <xsl:text/>
        <include item="SeeAlso"/>
        <xsl:text/>
      </a>
    </xsl:if>
    
    <!--all members only -->
    <xsl:if test="$subgroup='members'">
        <xsl:variable name="visibility">
          <xsl:for-each select="/document/reference/elements/element">
          <xsl:choose>
            <xsl:when test="memberdata[@visibility = 'public']">
              <xsl:choose>
                <xsl:when test="not(apidata[@subsubgroup])">
                  <xsl:value-of select="concat('Public', apidata/@subgroup, ';')"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="concat('Public', apidata/@subsubgroup, ';')"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:when test="memberdata[@visibility = 'private'] and not(proceduredata[@virtual = 'true'])">
              <xsl:choose>
                <xsl:when test="not(apidata[@subsubgroup])">
                  <xsl:value-of select="concat('Private', apidata/@subgroup, ';')"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="concat('Private', apidata/@subsubgroup, ';')"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:when test="memberdata[@visibility = 'private'] and proceduredata[@virtual = 'true']">
              explicit;
            </xsl:when>
            <xsl:otherwise>
              <xsl:choose>
                <xsl:when test="not(apidata[@subsubgroup])">
                  <xsl:value-of select="concat('Protected', apidata/@subgroup, ';')"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="concat('Protected', apidata/@subsubgroup, ';')"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:otherwise>
          </xsl:choose>
          </xsl:for-each>
        </xsl:variable>
      
      
      <xsl:for-each select="/document/reference/elements/element">
        <xsl:variable name="subgroup" select="apidata/@subgroup"/>
        <xsl:variable name="subsubgroup" select="apidata/@subsubgroup" />
        <xsl:if test="not(preceding-sibling::element[apidata[@subgroup=$subgroup]]) and not($subsubgroup='attachedProperty' or $subsubgroup='attachedEvent')">
          <xsl:if test="not($subsubgroup)">
            <xsl:variable name="elementVisibility">
              <xsl:choose>
                <xsl:when test="contains($visibility, concat('Public', $subgroup))">
                  <xsl:value-of select="concat('Public', $subgroup)"/>
                </xsl:when>
                <xsl:when test="contains($visibility, concat('Private', $subgroup))">
                  <xsl:value-of select="concat('Private', $subgroup)"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="concat('Protected', $subgroup)"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
            
            <!-- add a link to the member list section for this subgroup -->
            <a href="#{$elementVisibility}Toggle" onclick="OpenSection({$elementVisibility}Toggle)">
              <xsl:text/>
              <include item="{$subgroup}Group"/>
              <xsl:text/>
            </a>&#160;
          </xsl:if>
        </xsl:if>
        <xsl:if test="not(preceding-sibling::element[apidata[@subsubgroup=$subsubgroup]]) and ($subsubgroup='attachedProperty' or $subsubgroup='attachedEvent')">
          <xsl:variable name="elementVisibility">
            <xsl:choose>
              <xsl:when test="contains($visibility, concat('Public', $subsubgroup))">
                <xsl:value-of select="concat('Public', $subsubgroup)"/>
              </xsl:when>
              <xsl:when test="contains($visibility, concat('Private', $subsubgroup))">
                <xsl:value-of select="concat('Private', $subsubgroup)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="concat('Protected', $subsubgroup)"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <!-- add a link to the member list section for this subgroup -->
          <a href="#{$elementVisibility}Toggle" onclick="OpenSection({$elementVisibility}Toggle)">
            <xsl:text/>
            <include item="{$subsubgroup}Group"/>
            <xsl:text/>
          </a>&#160;
        </xsl:if>
      </xsl:for-each>

      <xsl:if test="contains($visibility, 'explicit')">
        <a href="#ExplicitInterfaceImplementationToggle" onclick="OpenSection(ExplicitInterfaceImplementationSection)">
          <xsl:text/>
          <include item="ExplicitInterfaceImplementation"/>
          <xsl:text/>
        </a>&#160;
      </xsl:if>
     </xsl:if>
        
  </xsl:template>

  <xsl:template name="bodyHeaderBottomTable">
    <table id="bottomTable" cellspacing="0" cellpadding="0">
      <tr>
        <td>
          <span onclick="ExpandCollapseAll(toggleAllImage)" style="cursor:default;" onkeypress="ExpandCollapseAll_CheckKey(toggleAllImage, event)" tabindex="0">
            <img ID="toggleAllImage" class="toggleAll">
              <includeAttribute name="src" item="iconPath">
                <parameter>collall.gif</parameter>
              </includeAttribute>
              <includeAttribute name="title" item="collapseAllImage" />
            </img>
            <label id="collapseAllLabel" for="toggleAllImage" style="display: none;">
              <include item="collapseAll"/>
            </label>
            <label id="expandAllLabel" for="toggleAllImage" style="display: none;">
              <include item="expandAll"/>
            </label>
            <xsl:text>&#160;</xsl:text>
          </span>

          <xsl:text>&#160;</xsl:text>
          
          <xsl:call-template name="languageFilterToolTip"/>

        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="languageFilterToolTip">
    <span id="languageFilterToolTip" style="cursor:default;" onmouseover="languageFilterImage.src=dropDownHoverImage.src;" onmouseout="languageFilterImage.src=dropDownImage.src;" tabindex="0">
      <img id="languageFilterImage">
        <includeAttribute name="src" item="iconPath">
          <parameter>twirl_unselected.gif</parameter>
        </includeAttribute>
	<includeAttribute name="title" item="dropDownImage" />
      </img>
      <xsl:for-each select="$languages/language">
        <label id="{@name}Label" for="languageFilterImage" style="display: none;">
          <include item="languageFilter">
            <parameter>
              <include item="{@label}Label"/>
            </parameter>
          </include>
        </label>
      </xsl:for-each>
    </span>
  </xsl:template>

  <xsl:template name="membersOptionsSpan">
    <div id="membersOptionsSpan">
      <input id="inheritedCheckbox" type='checkbox' name="membersOptionsFilter" onClick="SetMembersOptions(this)"/>
      <label class="membersOptionsFilter" for="inheritedCheckbox">
        <include item="includeInheritedMembers"/>
      </label>
      <br/>
      <input id="protectedCheckbox" type='checkbox' name="membersOptionsFilter" onClick="SetMembersOptions(this)"/>
      <label class="membersOptionsFilter" for="protectedCheckbox">
        <include item="includeProtectedMembers"/>
      </label>
      <br/>
      <input id="netcfCheckbox" type='checkbox' name="membersOptionsFilter" onClick="SetMembersOptions(this)"/>
      <label class="membersOptionsFilter" for="netcfCheckbox">
        <include item="netcfMembersOnly"/>
      </label>
      <br/>
      <!-- add a checkbox for XNA filtering -->
      <input id="netXnaCheckbox" type='checkbox' name="membersOptionsFilter" onClick="SetMembersOptions(this)"/>
      <label class="membersOptionsFilter" for="netXnaCheckbox">
        <include item="netXnaMembersOnly"/>
      </label>
    </div>
  </xsl:template>
  
  <xsl:template name="membersOptionsFilterToolTip">
    <span id="membersOptionsFilterToolTip" style="cursor:default;" onmouseover="membersOptionsFilterImage.src=dropDownHoverImage.src;" onmouseout="membersOptionsFilterImage.src=dropDownImage.src;" tabindex="0">
      <img id="membersOptionsFilterImage">
        <includeAttribute name="src" item="iconPath">
          <parameter>drpdown.gif</parameter>
        </includeAttribute>
        <includeAttribute name="title" item="dropDownImage" />
      </img>
      <label id="showAllMembersLabel" for="membersOptionsFilterImage" style="display: none;">
        <include item="membersOptionsShowAll"/>
      </label>
      <label id="filteredMembersLabel" for="membersOptionsFilterImage" style="display: none;">
        <include item="membersOptionsFiltered"/>
      </label>
    </span>
  </xsl:template>
  
  <xsl:template name="languageSpan">
    <div id="languageSpan">
      <xsl:for-each select="$languages/language">
        <div id="{@name}" onclick="changeLanguage(data, '{@name}', '{@style}');">
          <img id="{@name}Image" onmouseover="mouseOverCheck({@name}Image,radioSelectImage,radioUnSelectImage,radioSelectHoverImage,radioUnSelectHoverImage)" onmouseout="mouseOutCheck({@name}Image,radioSelectImage,radioUnSelectImage,radioSelectHoverImage,radioUnSelectHoverImage)">
            <includeAttribute name="src" item="iconPath">
              <parameter>r_unselect.gif</parameter>
            </includeAttribute>
          </img>
          <xsl:text>&#xa0;</xsl:text>
          <include item="{@label}Label" />
        </div>
        <br />
      </xsl:for-each>
    </div>
  </xsl:template>
      


  <!-- image links 
current ndppick XSLT behavior:
expandAllImage - all
dropDownImage - not namespace or derivedTypeList
dropDownHoverImage -  not namespace or derivedTypeList
collapseImage - all
expandImage - all
collapseAllImage - all
copyImage - overview (not namespace); list (only overload lists ctor, method, prop)
copyHoverImage - overview (not namespace); list (only overload lists ctor, method, prop)
  -->
  <xsl:template name="commonImages">
    <img id="collapseImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>collapse_all.gif</parameter>
      </includeAttribute>
      <includeAttribute name="title" item="collapseImage" />
    </img>
    <img id="expandImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>expand_all.gif</parameter>
      </includeAttribute>
      <includeAttribute name="title" item="expandImage" />
    </img>
    <img id="collapseAllImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>collall.gif</parameter>
      </includeAttribute>
      <includeAttribute name="title" item="collapseAllImage" />
    </img>
    <img id="expandAllImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>expall.gif</parameter>
      </includeAttribute>
      <includeAttribute name="title" item="expandAllImage" />
    </img>
    <img id="dropDownImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>twirl_unselected.gif</parameter>
      </includeAttribute>
      <includeAttribute name="title" item="dropDownImage" />
    </img>
    <img id="dropDownHoverImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>twirl_unselected_hover.gif</parameter>
      </includeAttribute>
      <includeAttribute name="title" item="dropDownHoverImage" />
    </img>
    <img id="copyImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>copycode.gif</parameter>
      </includeAttribute>
      <includeAttribute name="title" item="copyImage" />
    </img>
    <img id="copyHoverImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>copycodeHighlight.gif</parameter>
      </includeAttribute>
      <includeAttribute name="title" item="copyHoverImage" />
    </img>
    <img id="checkBoxSelectImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>ch_selected.gif</parameter>
      </includeAttribute>
    </img>
    <img id="checkBoxUnSelectImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>ch_unselected.gif</parameter>
      </includeAttribute>
    </img>
    <img id="checkBoxSelectHoverImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>ch_selected_hover.gif</parameter>
      </includeAttribute>
    </img>
    <img id="checkBoxUnSelectHoverImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>ch_unselected_hover.gif</parameter>
      </includeAttribute>
    </img>
    <img id="radioSelectImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>r_select.gif</parameter>
      </includeAttribute>
    </img>
    <img id="radioUnSelectImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>r_unselect.gif</parameter>
      </includeAttribute>
    </img>
    <img id="radioSelectHoverImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>r_select_hover.gif</parameter>
      </includeAttribute>
    </img>
    <img id="radioUnSelectHoverImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>r_unselect_hover.gif</parameter>
      </includeAttribute>
    </img>
    <img id="curvedLeftSelectImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>tab_sel_lft_cnr.gif</parameter>
      </includeAttribute>
    </img>
    <img id="curvedRightSelectImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>tab_sel_rt_cnr.gif</parameter>
      </includeAttribute>
    </img>
    <img id="curvedLeftUnSelectImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>tab_unsel_lft_cnr.gif</parameter>
      </includeAttribute>
    </img>
    <img id="curvedRightUnSelectImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>tab_unsel_rt_cnr.gif</parameter>
      </includeAttribute>
    </img>
    <img id="gradLeftSelectImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>tab_sel_lft_grad.gif</parameter>
      </includeAttribute>
    </img>
    <img id="gradRightSelectImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>tab_sel_rt_grad.gif</parameter>
      </includeAttribute>
    </img>
    <img id="gradLeftUnSelectImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>tab_unsel_lft_grad.gif</parameter>
      </includeAttribute>
    </img>
    <img id="gradRightUnSelectImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>tab_unsel_rt_grad.gif</parameter>
      </includeAttribute>
    </img>
    <img id="twirlSelectImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>twirl_selected.gif</parameter>
      </includeAttribute>
    </img>
    <img id="twirlUnSelectImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>twirl_unselected.gif</parameter>
      </includeAttribute>
    </img>
    <img id="twirlSelectHoverImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>twirl_selected_hover.gif</parameter>
      </includeAttribute>
    </img>
    <img id="twirlUnSelectHoverImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>twirl_unselected_hover.gif</parameter>
      </includeAttribute>
    </img>
    <img id="NSRBottomImage" style="display:none; height:0; width:0;">
      <includeAttribute name="src" item="iconPath">
        <parameter>NSRbottomgrad.gif</parameter>
      </includeAttribute>
    </img>
  </xsl:template>

  
</xsl:stylesheet>